<?php
require_once '../config/config.php';

if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    
    try {
    $stmt = $conn->prepare("SELECT * FROM blogs WHERE id = ?");
        $stmt->execute([$id]);
        $blog = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($blog) {
            header('Content-Type: application/json');
            echo json_encode($blog);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'blog not found']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error']);
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'No blog ID provided']);
}